// Vysilac

#include "main.h"
#include "..\common.h"
//Displej
#DEFINE  LCD_RS         PIN_B1      // rizeni registru LCD displeje
#DEFINE  LCD_E          PIN_B2      // enable LCD displeje
#DEFINE  LCD_DATA_LSB   PIN_B4      // pripojeni LSB bitu datoveho portu LCD displeje (celkem 4 bity vzestupne za sebou)
#INCLUDE "MYLCD.C"
#INCLUDE "lcd2.c"
//Klavesnice
#DEFINE  PL             PIN_B3              // ovladani klavesnice
#DEFINE  STROBE_LED     PIN_C0
#DEFINE  STROBE_KL      PIN_C1
#DEFINE  DATA_OUT       PIN_C2
#DEFINE  CP             PIN_C3
#DEFINE  DATA_IN        PIN_C4
#INCLUDE "keybord.c"
//Vysilac
#DEFINE  VYSILAC        PIN_C5
#INCLUDE "vysilac.c"
//Joistick
#DEFINE  EEleve_x           0
#DEFINE  EEprave_x          1          //adresovani EEPROM
#DEFINE  EEhorni_y          2
#DEFINE  EEdolni_y          3

#DEFINE  EEmin_x            4
#DEFINE  EEmax_x            5
#DEFINE  EEmin_y            6
#DEFINE  EEmax_y            7
#DEFINE  EEstred_x          8
#DEFINE  EEstred_y          9

#DEFINE  AD_OSA_X          1           // adresa A/D prevodniku pro osu X
#DEFINE  AD_OSA_Y          0           // adresa A/D prevodniku pro osu Y
#DEFINE  TL1            PIN_C6
#DEFINE  TL2            PIN_C7
#INCLUDE "Joystick.c"

int  x,y,tlac1,tlac2;

void trimovat()
{
   odeslat_paket(Trim,0b0001);
   odeslat_paket(OSA_X,x);
   odeslat_paket(OSA_Y,y);
}

void vysilat()
{

   leve_x = read_eeprom(EEleve_x);
   prave_x = read_eeprom(EEprave_x);
   stred_x = read_eeprom(EEstred_x);
   stred_y = read_eeprom(EEstred_y);
   horni_y = read_eeprom(EEhorni_y);
   dolni_y = read_eeprom(EEdolni_y);

   Delay_ms(200);
   lcd_gotoxy(6,2);
   printf(lcd_putc,"Vysilam");

   while(0x80 == klavesa())
      {
         Joystick(&x,&y,&tlac1,&tlac2);
         /*if (stred_x >= x)
         {
            x = stred_x - x;
            x = x/leve_x;
         }
         else
         {
            x = x - stred_x;
            x = x/prave_x;
         }

         if (stred_y >= y)
         {
            y = stred_y - y;
            y = y/dolni_y;
         }
         else
         {
            y = y - stred_y;
            y = y/horni_y;
         }*/

         x=x/8;
         y=y/8;

        odeslat_paket(OSA_X,x);
        Delay_us(1600);
        odeslat_paket(OSA_Y,y);
   }
}

void menu()
{
int8 polozka = 3;
int8 old_polozka = 0;
int pom;

   while(true)
   {
      pom = klavesa();
      if (0x07 == pom) polozka++;
      if (0x0f == pom) polozka--;
      if (0x04 <= polozka) polozka = 1;
      if (0x00 == polozka) polozka = 3;
      if (0x16 == pom)   // enter
      {
         LED((1 << (polozka + 1)) | 1);
         switch(polozka)
         {
            case 1:
              kalibrace();
              break;

            case 2:
              trimovat();
              break;

            case 3:
              vysilat();
              break;
         };
         LED(1 << (polozka + 1));
         old_polozka=0;
      };

      if (polozka != old_polozka)
      {
         old_polozka=polozka;
         printf(lcd_putc,"\f");
         switch(polozka)
         {
            case 1:
              lcd_gotoxy(5,2);
              printf(lcd_putc,"Kalibrace");
              break;

            case 2:
              lcd_gotoxy(7,2);
              printf(lcd_putc,"Trim");
              break;

            case 3:
              lcd_gotoxy(6,2);
              printf(lcd_putc,"Vysilat");
              break;
         };
         LED(1 << (polozka + 1));
         Delay_ms(250);
      }
   }
}

void main()
{
int8 tlacitka,tlacitka_old;
   setup_adc_ports(RA0_RA1_RA3_ANALOG);
   setup_adc(ADC_CLOCK_DIV_2);
   setup_spi(FALSE);
   setup_counters(RTCC_INTERNAL,RTCC_DIV_2);
   setup_timer_1(T1_DISABLED);
   setup_timer_2(T2_DISABLED,0,1);

   lcd_init();
   KL_init();

   menu();

while(true)
{
//char xx;
//      if (true == read_kl(&xx))
//      {
//      printf(lcd_putc,"%C",xx );
//      }
}
}
