// Vysilac

#include "main.h"
#include "..\common.h"

#DEFINE  LCD_RS         PIN_B1      // rizeni registru LCD displeje
#DEFINE  LCD_E          PIN_B2      // enable LCD displeje
#DEFINE  LCD_DATA_LSB   PIN_B4      // pripojeni LSB bitu datoveho portu LCD displeje (celkem 4 bity vzestupne za sebou)
#INCLUDE "MYLCD.C"

#DEFINE  VYSILAC        PIN_C3
#DEFINE  AD_OSA_X          0           // adresa A/D prevodniku pro osu X
#DEFINE  AD_OSA_Y          1           // adresa A/D prevodniku pro osu Y
#DEFINE  TTL1           PIN_B4
#DEFINE  TTL2           PIN_B3


// Odesle nulu nebo jednicku podle nejnizsiho bitu predanych dat
// Nula je posloupnost LH a jednicka je HL
//
void odeslat_bit(int8 data)
{
   output_bit(VYSILAC,bit_test(data,0));
   delay_us(IMPULS);
   output_bit(VYSILAC,!bit_test(data,0));
   delay_us(IMPULS);
}


// Odelse ramec o 4 bitech
// Datovy ramec zacina 11, synchronizacni ramec zacina 10
//
void odeslat_nibble(int1 datovy, int8 data)
{
   int i;

   delay_ms(3);            // klidovy stav na lince

   odeslat_bit(1);         // start bit
   odeslat_bit(datovy);

   for (i=5; --i!=0; )     // datove bity
   {
      odeslat_bit(data);
      data>>=1;
   }

   output_low(VYSILAC);    // klidovy stav
}


void odeslat_paket(int8 kanal, data)
{
   int8 suma;

   suma = kanal+data;
   odeslat_nibble(0,0b1111);  // Synchronizace
   odeslat_nibble(1,kanal);   // Identifikace osy
   odeslat_nibble(1,data);    // Hodnota osy
   odeslat_nibble(1,suma);    // Kontrolni soucet

   delay_ms(10);              // cas pro prijimac aby mohl zpracovat data
                              // mozno nahradit vysilanim jednicek
}


int stredX, stredY, x, y;

void kalibrace()
{
int8 min_x;
int8 max_x;
int8 min_y;
int8 max_y;
int8 sred_x;
int8 sred_y;
int8 adc;
   min_x=max_x=min_y=max_y=sred_x=sred_y=128;

   printf(lcd_putc,"Paku dejte do prostred a stisknete tlacitko");
znovu:
   if (TTL1 || TTL2)
   {
   set_adc_channel(AD_OSA_X);
   delay_us(10);
   sred_x=read_adc();
   set_adc_channel(AD_OSA_Y);
   delay_us(10);
   sred_y=read_adc();
   };

   //else goto znovu;

   printf(lcd_putc,"\f");
   printf(lcd_putc,"Pak ");

   set_adc_channel(AD_OSA_X);
   delay_us(10);

   adc=read_adc();

   if (max_x < adc )max_x=adc;
   if (min_x > adc )min_x=adc;

   set_adc_channel(AD_OSA_Y);
   delay_us(10);

   adc=read_adc();

   if (max_y < adc )max_y=adc;
   if (min_y > adc )min_y=adc;

   if (TTL1 || TTL2) return;
}


void main()
{

   setup_adc_ports(RA0_RA1_RA3_ANALOG);
   setup_adc(ADC_CLOCK_DIV_2);
   setup_spi(FALSE);
   setup_counters(RTCC_INTERNAL,RTCC_DIV_2);
   setup_timer_1(T1_DISABLED);
   setup_timer_2(T2_DISABLED,0,1);

   lcd_init();
   printf(lcd_putc,"\fAhoj!");
   delay_ms(300);

   while(true)
   {
      set_adc_channel(AD_OSA_X);
      lcd_gotoxy(1,1);
      x=read_adc() >> 4;
      printf(lcd_putc,"X: %D      ", x);
      set_adc_channel(AD_OSA_Y);
      lcd_gotoxy(1,2);
      y=read_adc() >> 4;
      printf(lcd_putc,"Y: %D      ", y);

      odeslat_paket(OSA_X,x);
      odeslat_paket(OSA_Y,y);

   }

}
