
//#DEFINE  DEBUG          PIN_A4      // ladici pomocne synchronizacni impulzy

//#DEFINE  PRIJIMAC       PIN_A3      // pin na ktery je pripojen prijimac

// Prijme datovy nibble vcetne zasynchronizovani
// Chybi dodelat timeout
int8 prijmi_nibble(int8* datovy, int8* data)
{
   int8 i;

   #IFDEF DEBUG
   int1 tmp;
   #ENDIF

   *data=0;

   // Cekam na dlouhou nulu
   for (i=4; i>0; i--)
   {
      if (input(PRIJIMAC)) i=4;
      delay_us(IMPULS/2);
   }

   // Cekam na jednicku (start ramce)
   for (; !input(PRIJIMAC); )
   {
   }

   // Ctu typ nibblu
   delay_us(2*IMPULS+2*IMPULS/3);
   *datovy=input(PRIJIMAC);

   // Prenasim bity
   for (i=0; i<4; i++)
   {
      delay_us(2*IMPULS);
      *data >>= 1;
      if (input(PRIJIMAC)) *data +=0b1000;

      #IFDEF DEBUG
      output_bit(DEBUG,tmp);
      tmp=!tmp;
      #ELSE
      delay_us(20);
      #ENDIF
   }

   return FALSE;
}


// Prijme datovy ramec
// Pokud nastane chyba vraci kod chyby
int8 prijmi_ramec(int8* kanal, int8* data)
{
   int8 datovy;
   int8 suma;

   // Cekej na synchronizacni nibble
   do
   {
      if (prijmi_nibble(&datovy, data)) return 1;     // chyba timout
   }
   while(datovy);

   // Zkontroluj magickou hodnotu
   if (*data != SYNC_NIBBLE) return 2;                // chyba magickeho kodu ramce

   // Prijmi cislo kanalu
   if (prijmi_nibble(&datovy, kanal)) return 1;      // chyba timeout
   if (!datovy) return 3;                             // chyba typu nibblu

   // Prijmi data
   if (prijmi_nibble(&datovy, data)) return 1;       // chyba timeout
   if (!datovy) return 3;                             // chyba typu nibblu

   // Prijmi zabezpeceni
   if (prijmi_nibble(&datovy, &suma)) return 1;       // chyba timeout
   if (!datovy) return 3;                             // chyba typu nibblu

   // Zkontroluj kontrolni soucet
   if (((*kanal+*data) & 0b1111) != suma) return 3;     // chyba kontrolniho souctu

   return 0;
}

