//#DEFINE  PL             PIN_B3              // ovladani klavesnice
//#DEFINE  STROBE_LED     PIN_C0
//#DEFINE  STROBE_KL      PIN_C1
//#DEFINE  DATA_OUT       PIN_C2
//#DEFINE  CP             PIN_C3
//#DEFINE  DATA_IN        PIN_C4

#DEFINE  znak_0     14
#DEFINE  znak_1     10
#DEFINE  znak_2     11
#DEFINE  znak_3     12
#DEFINE  znak_4     20
#DEFINE  znak_5     21
#DEFINE  znak_6     22
#DEFINE  znak_7     04
#DEFINE  znak_8     05
#DEFINE  znak_9     06
#DEFINE  znak_R     15
#DEFINE  znak_F     16
#DEFINE  znak_C     27
#DEFINE  nic        80


void KL_init()
{
int8 i;
   output_high(STROBE_KL);
   output_high(STROBE_LED);

   for (i=0;i<=7;i++)
   {
      output_low(DATA_IN);
      output_high(CP);
      output_low(CP);
   }
   output_low(STROBE_KL);
   output_low(STROBE_LED);
   output_high(CP);
   output_high(PL);
}

void KL_CP(j)
{
int8 i;
   for (i=0;i<=j;i++)
   {
      output_high(CP);
      output_low(CP);
   }
}

void LED(int8 LED)      //rosviti LED 1-7
{
int i;
   output_low(CP);
   output_low(STROBE_LED);
   for (i=0;i<=7;i++)
   {
      output_bit(DATA_IN,bit_test(LED,i));
      output_high(CP);
      output_low(CP);
   };
   output_high(STROBE_LED);
   output_low(STROBE_LED);
}

int8 klavesa()          //vrati cislo klavesy
{
   int8 i;
   int8 sloupec;

   for(sloupec=0; sloupec<=7; sloupec++)
   {
      output_low(STROBE_KL);
      output_low(DATA_IN);
      for (i=0;i<=7;i++)
      {                                   //nulovani sloupcu
        output_high(CP);
        output_low(CP);
      }

      output_high(DATA_IN);
      output_high(CP);                    //zavedeni 1 do registru sloupcu
      output_low(CP);

      output_low(DATA_IN);
      for (i=0;i<sloupec;i++)            //nastaveni sloupce
      {
        output_high(CP);
        output_low(CP);
      }

      output_high(STROBE_KL);
      output_low(PL);
      output_high(PL);

      for (i=0;i<5;i++)                  //posunuti cteciho registru
      {
        output_high(CP);
        output_low(CP);
      }

     /* if (1==input(DATA_OUT)) return(sloupec);           // pokud je 4. radek
      output_high(CP);
      output_low(CP);
      if (1==input(DATA_OUT)) return(sloupec);           // pokud je 3. radek
      output_high(CP);
      output_low(CP);*/
      if (1==input(DATA_OUT)) return(sloupec);           // pokud je 0. radek
      output_high(CP);
      output_low(CP);
      if (1==input(DATA_OUT)) return(0b1000 | sloupec);  // pokud je 1. radek
      output_high(CP);
      output_low(CP);
      if (1==input(DATA_OUT)) return(0b10000 | sloupec); // pokud je 2. radek


   }
   return(0x80);  // nastavy nejvissi bit, ze neni nic zmacknuto
}

boolean read_KL(char *klv)
{
   const char prev_tabulka[24]={'i','z','m','u','7','8','9','.','1','2','3','b','0','r','f','k','4','5','6','s',' ',' ','t','c'};

   *klv = klavesa();
   if (0x80==*klv) return(false);
   else
   {
      *klv = prev_tabulka[*klv];
      return(true);
   }
}

